/* - GPSPositionChangeListener -
 * Display the data from a GPS position change event
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.GPSPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.GPSPositionChangeEvent;
import com.phidgets.event.GPSPositionChangeListener;
import javax.swing.JTextField;

public class GPositionChangeListener implements GPSPositionChangeListener {

    private final char DEGREESYMBOL = '\u00b0';
    private JTextField latTxt;
    private JTextField longTxt;
    private JTextField altTxt;
    private JTextField velTxt;
    private JTextField headTxt;

    public GPositionChangeListener(JTextField latTxt, JTextField longTxt, JTextField altTxt, JTextField velTxt,
            JTextField headTxt) {
        this.latTxt = latTxt;
        this.longTxt = longTxt;
        this.altTxt = altTxt;
        this.velTxt = velTxt;
        this.headTxt = headTxt;
    }

    public void gpsPositionChanged(GPSPositionChangeEvent gpsPositionChangeEvent) {

        GPSPhidget gps = (GPSPhidget) gpsPositionChangeEvent.getSource();

        latTxt.setText(Double.toString(gpsPositionChangeEvent.getLatitude()) + DEGREESYMBOL);
        longTxt.setText(Double.toString(gpsPositionChangeEvent.getLongitude()) + DEGREESYMBOL);
        altTxt.setText(Double.toString(gpsPositionChangeEvent.getAltitude()) + "m");
        try {
            velTxt.setText(Double.toString(gps.getVelocity()) + "km/h");
            headTxt.setText(Double.toString(gps.getHeading()) + DEGREESYMBOL);
        } catch (PhidgetException ex) {
            velTxt.setText("Unknown");
            headTxt.setText("Unknown");
        }
    }
}
